const fs = require('fs');
const path = require('path');

console.log('\n' + '='.repeat(80));
console.log('KUZADESIGN STAKING - SYSTEM VERIFICATION');
console.log('='.repeat(80) + '\n');

const checks = [];

// 1. Check Contracts
console.log('1. SMART CONTRACTS');
const contractToken = fs.existsSync('contracts/KUZADESIGNToken.sol');
const contractStaking = fs.existsSync('contracts/KZDStaking.sol');
console.log('   Token Contract:', contractToken ? '✅' : '❌');
console.log('   Staking Contract:', contractStaking ? '✅' : '❌');
checks.push(contractToken && contractStaking);

// 2. Check Models
console.log('\n2. DATABASE MODELS');
const modelFiles = ['User.js', 'Stake.js', 'Balance.js', 'Transaction.js'];
let allModelsExist = true;
modelFiles.forEach(file => {
    const exists = fs.existsSync(`models/${file}`);
    console.log(`   ${file}:`, exists ? '✅' : '❌');
    allModelsExist = allModelsExist && exists;
});
checks.push(allModelsExist);

// 3. Check API Routes
console.log('\n3. API ROUTES');
const apiRoutes = [
    'api/auth/register.js',
    'api/stake/create.js',
    'api/stake/list.js',
    'api/balance/get.js',
    'api/withdraw/request.js',
    'api/team/stats.js',
    'api/transactions/history.js'
];
let allApisExist = true;
apiRoutes.forEach(route => {
    const exists = fs.existsSync(`pages/${route}`);
    console.log(`   ${route}:`, exists ? '✅' : '❌');
    allApisExist = allApisExist && exists;
});
checks.push(allApisExist);

// 4. Check Frontend Pages
console.log('\n4. FRONTEND PAGES');
const pages = ['index.js', 'stake.js', 'team.js', 'withdraw.js', 'profile.js'];
let allPagesExist = true;
pages.forEach(page => {
    const exists = fs.existsSync(`pages/${page}`);
    console.log(`   ${page}:`, exists ? '✅' : '❌');
    allPagesExist = allPagesExist && exists;
});
checks.push(allPagesExist);

// 5. Check Libraries
console.log('\n5. HELPER LIBRARIES');
const libs = ['mongodb.js', 'web3Config.js', 'referralSystem.js', 'managerSystem.js'];
let allLibsExist = true;
libs.forEach(lib => {
    const exists = fs.existsSync(`lib/${lib}`);
    console.log(`   ${lib}:`, exists ? '✅' : '❌');
    allLibsExist = allLibsExist && exists;
});
checks.push(allLibsExist);

// 6. Check Components
console.log('\n6. COMPONENTS');
const components = ['WalletConnect.js', 'BottomNav.js'];
let allComponentsExist = true;
components.forEach(comp => {
    const exists = fs.existsSync(`components/${comp}`);
    console.log(`   ${comp}:`, exists ? '✅' : '❌');
    allComponentsExist = allComponentsExist && exists;
});
checks.push(allComponentsExist);

// 7. Check Scripts
console.log('\n7. SCRIPTS');
const scripts = ['deploy.js', 'dailyRewards.js'];
let allScriptsExist = true;
scripts.forEach(script => {
    const exists = fs.existsSync(`scripts/${script}`);
    console.log(`   ${script}:`, exists ? '✅' : '❌');
    allScriptsExist = allScriptsExist && exists;
});
checks.push(allScriptsExist);

// 8. Check Configuration
console.log('\n8. CONFIGURATION');
const configs = [
    { file: '.env', name: 'Environment' },
    { file: '.env.local', name: 'Frontend Env' },
    { file: 'hardhat.config.js', name: 'Hardhat Config' },
    { file: 'next.config.js', name: 'Next.js Config' },
    { file: 'package.json', name: 'Package Config' }
];
let allConfigsExist = true;
configs.forEach(({ file, name }) => {
    const exists = fs.existsSync(file);
    console.log(`   ${name}:`, exists ? '✅' : '❌');
    allConfigsExist = allConfigsExist && exists;
});
checks.push(allConfigsExist);

// 9. Check Deployment
console.log('\n9. DEPLOYMENT STATUS');
const deployedData = fs.existsSync('deployed-addresses.json');
console.log('   Contract Addresses:', deployedData ? '✅ DEPLOYED' : '❌ NOT DEPLOYED');
if (deployedData) {
    const deployed = JSON.parse(fs.readFileSync('deployed-addresses.json', 'utf8'));
    console.log('   Token:', deployed.tokenAddress);
    console.log('   Staking:', deployed.stakingAddress);
    console.log('   Network:', deployed.network);
}
checks.push(deployedData);

// 10. Check Documentation
console.log('\n10. DOCUMENTATION');
const docs = ['README.md', 'DEPLOYMENT.md', 'QUICKSTART.md', 'START_HERE.md'];
let allDocsExist = true;
docs.forEach(doc => {
    const exists = fs.existsSync(doc);
    console.log(`   ${doc}:`, exists ? '✅' : '❌');
    allDocsExist = allDocsExist && exists;
});
checks.push(allDocsExist);

// Summary
console.log('\n' + '='.repeat(80));
console.log('VERIFICATION SUMMARY');
console.log('='.repeat(80));

const totalChecks = checks.length;
const passedChecks = checks.filter(c => c).length;
const percentage = ((passedChecks / totalChecks) * 100).toFixed(0);

console.log(`\nPassed: ${passedChecks}/${totalChecks} checks (${percentage}%)`);

if (passedChecks === totalChecks) {
    console.log('\n🎉 SEMUA KOMPONEN LENGKAP DAN SIAP!');
    console.log('\nNext Steps:');
    console.log('1. Start server: npm run dev');
    console.log('2. Open: http://localhost:3000');
    console.log('3. Connect wallet & test staking!');
} else {
    console.log('\n⚠️  Beberapa komponen tidak ditemukan!');
    console.log('Please check the items marked with ❌ above.');
}

console.log('\n' + '='.repeat(80) + '\n');
