const fs = require('fs');

// Read deployed addresses
const deployed = JSON.parse(fs.readFileSync('deployed-addresses.json', 'utf8'));

console.log('\n='.repeat(80));
console.log('UPDATING ENVIRONMENT FILES');
console.log('='.repeat(80));

// Create .env.local for frontend
const envLocal = `# Frontend Environment Variables
# Auto-generated from deployment

NEXT_PUBLIC_KZD_TOKEN_ADDRESS=${deployed.tokenAddress}
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=${deployed.stakingAddress}
`;

fs.writeFileSync('.env.local', envLocal);
console.log('\n✅ Created .env.local with contract addresses');

// Read current .env
let envContent = fs.readFileSync('.env', 'utf8');

// Update or add addresses
if (envContent.includes('KZD_TOKEN_ADDRESS=')) {
    envContent = envContent.replace(/KZD_TOKEN_ADDRESS=.*/g, `KZD_TOKEN_ADDRESS=${deployed.tokenAddress}`);
} else {
    envContent += `\nKZD_TOKEN_ADDRESS=${deployed.tokenAddress}`;
}

if (envContent.includes('STAKING_CONTRACT_ADDRESS=')) {
    envContent = envContent.replace(/STAKING_CONTRACT_ADDRESS=.*/g, `STAKING_CONTRACT_ADDRESS=${deployed.stakingAddress}`);
} else {
    envContent += `\nSTAKING_CONTRACT_ADDRESS=${deployed.stakingAddress}`;
}

fs.writeFileSync('.env', envContent);
console.log('✅ Updated .env with contract addresses\n');

console.log('='.repeat(80));
console.log('CONTRACT ADDRESSES');
console.log('='.repeat(80));
console.log('\nToken Address:');
console.log(deployed.tokenAddress);
console.log('\nStaking Address:');
console.log(deployed.stakingAddress);
console.log('\n' + '='.repeat(80));
console.log('VIEW ON BSCSCAN TESTNET');
console.log('='.repeat(80));
console.log(`\nToken:   https://testnet.bscscan.com/address/${deployed.tokenAddress}`);
console.log(`Staking: https://testnet.bscscan.com/address/${deployed.stakingAddress}`);
console.log('\n' + '='.repeat(80) + '\n');
