require('dotenv').config();
const mongoose = require('mongoose');

async function testMongoDB() {
    console.log('\n' + '='.repeat(80));
    console.log('MONGODB CONNECTION TEST');
    console.log('='.repeat(80));

    const mongoUri = process.env.MONGODB_URI || 'mongodb://localhost:27017/kuzastaking';

    console.log('\n📊 Connection Details:');
    console.log('URI:', mongoUri);

    try {
        console.log('\n🔄 Connecting to MongoDB...');
        await mongoose.connect(mongoUri);

        console.log('✅ MongoDB Connected Successfully!');

        // Test database
        console.log('\n📂 Database Info:');
        console.log('Database Name:', mongoose.connection.name);
        console.log('Connection State:', mongoose.connection.readyState === 1 ? 'Connected' : 'Disconnected');
        console.log('Host:', mongoose.connection.host);
        console.log('Port:', mongoose.connection.port);

        // List collections
        const collections = await mongoose.connection.db.listCollections().toArray();
        console.log('\n📋 Collections:', collections.length > 0 ? collections.map(c => c.name).join(', ') : 'None yet (will be created on first use)');

        console.log('\n' + '='.repeat(80));
        console.log('✅ MONGODB SIAP DIGUNAKAN!');
        console.log('='.repeat(80) + '\n');

        await mongoose.connection.close();
        process.exit(0);

    } catch (error) {
        console.log('\n❌ MongoDB Connection Failed!');
        console.log('Error:', error.message);
        console.log('\n💡 Troubleshooting:');
        console.log('1. Check if MongoDB service is running:');
        console.log('   Get-Service -Name "MongoDB"');
        console.log('2. Start MongoDB if stopped:');
        console.log('   net start MongoDB');
        console.log('3. Verify connection string in .env');
        console.log('\n' + '='.repeat(80) + '\n');
        process.exit(1);
    }
}

testMongoDB();
