const fs = require('fs');
const data = JSON.parse(fs.readFileSync('deployed-addresses.json', 'utf8'));

const output = `
================================================================================
KUZADESIGN STAKING - DEPLOYED TO BSC TESTNET
================================================================================

KZD Token Address:
${data.tokenAddress}

Staking Contract Address:
${data.stakingAddress}

Deployer Address:
${data.deployer}

Network: ${data.network}
Timestamp: ${data.timestamp}

================================================================================
ADD TO .env FILE:
================================================================================
KZD_TOKEN_ADDRESS=${data.tokenAddress}
STAKING_CONTRACT_ADDRESS=${data.stakingAddress}

================================================================================
ADD TO .env.local FILE:
================================================================================
NEXT_PUBLIC_KZD_TOKEN_ADDRESS=${data.tokenAddress}
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=${data.stakingAddress}

================================================================================
VERIFY ON BSCSCAN:
================================================================================
npx hardhat verify --network bscTestnet ${data.tokenAddress}
npx hardhat verify --network bscTestnet ${data.stakingAddress} ${data.tokenAddress}

================================================================================
VIEW ON BSCSCAN:
================================================================================
Token: https://testnet.bscscan.com/address/${data.tokenAddress}
Staking: https://testnet.bscscan.com/address/${data.stakingAddress}

================================================================================
`;

console.log(output);
fs.writeFileSync('DEPLOYED_ADDRESSES.txt', output);
console.log('✅ Saved to DEPLOYED_ADDRESSES.txt\n');
