require('dotenv').config();
const cron = require('node-cron');
const { exec } = require('child_process');
const path = require('path');

console.log('🚀 KUZADESIGN Daily Rewards Scheduler Started');
console.log('='.repeat(60));
console.log('📅 Current Time:', new Date().toLocaleString('id-ID'));
console.log('⏰ Schedule: Every day at 00:00 (midnight)');
console.log('🔄 Status: Running...');
console.log('='.repeat(60) + '\n');

// Run daily at midnight (00:00)
// Cron format: second minute hour day month day-of-week
cron.schedule('0 0 * * *', () => {
    console.log('\n' + '='.repeat(60));
    console.log('🕐 DAILY REWARDS TRIGGER');
    console.log('📅 Time:', new Date().toLocaleString('id-ID'));
    console.log('='.repeat(60));

    const scriptPath = path.join(__dirname, 'dailyRewards.js');

    exec(`node "${scriptPath}"`, (error, stdout, stderr) => {
        if (error) {
            console.error('❌ Error executing daily rewards:', error);
            return;
        }

        if (stderr) {
            console.error('⚠️  Error output:', stderr);
        }

        console.log(stdout);
        console.log('✅ Daily rewards calculation completed');
        console.log('='.repeat(60) + '\n');
    });
}, {
    scheduled: true,
    timezone: "Asia/Jakarta"
});

// Also run immediately on startup (for testing)
if (process.argv.includes('--test-now')) {
    console.log('🧪 TEST MODE: Running rewards immediately...\n');
    const scriptPath = path.join(__dirname, 'dailyRewards.js');

    exec(`node "${scriptPath}"`, (error, stdout, stderr) => {
        if (error) {
            console.error('❌ Error:', error);
            return;
        }
        if (stderr) {
            console.error('⚠️  Error output:', stderr);
        }
        console.log(stdout);
    });
}

// Keep the process running
console.log('💡 Scheduler is running. Press Ctrl+C to stop.\n');
console.log('📊 Next execution: Tomorrow at 00:00 Asia/Jakarta\n');

// Heartbeat every hour to show it's alive
cron.schedule('0 * * * *', () => {
    console.log(`💓 Heartbeat: ${new Date().toLocaleString('id-ID')} - Scheduler running...`);
});
