require('dotenv').config();
const hre = require("hardhat");
const fs = require('fs');

async function main() {
    console.log("\n" + "=".repeat(70));
    console.log("DEPLOYING KUZADESIGN STAKING TO BSC TESTNET");
    console.log("=".repeat(70) + "\n");

    const [deployer] = await hre.ethers.getSigners();
    console.log("Deployer Address:", deployer.address);

    const balance = await hre.ethers.provider.getBalance(deployer.address);
    console.log("Balance:", hre.ethers.formatEther(balance), "BNB\n");

    // Deploy Token
    console.log("1. Deploying KZD Token...");
    const KZDToken = await hre.ethers.getContractFactory("KUZADESIGNToken");
    const kzdToken = await KZDToken.deploy();
    await kzdToken.waitForDeployment();
    const tokenAddress = await kzdToken.getAddress();
    console.log("   ✅ Token Address:", tokenAddress);

    // Deploy Staking
    console.log("\n2. Deploying Staking Contract...");
    const KZDStaking = await hre.ethers.getContractFactory("KZDStaking");
    const staking = await KZDStaking.deploy(tokenAddress);
    await staking.waitForDeployment();
    const stakingAddress = await staking.getAddress();
    console.log("   ✅ Staking Address:", stakingAddress);

    // Transfer tokens
    console.log("\n3. Transferring 100,000 KZD to staking contract...");
    const tx = await kzdToken.transfer(stakingAddress, hre.ethers.parseEther("100000"));
    await tx.wait();
    console.log("   ✅ Transfer complete!");

    // Summary
    console.log("\n" + "=".repeat(70));
    console.log("DEPLOYMENT SUCCESSFUL!");
    console.log("=".repeat(70));
    console.log("\nToken Address:   ", tokenAddress);
    console.log("Staking Address: ", stakingAddress);
    console.log("Network:         ", hre.network.name);
    console.log("Deployer:        ", deployer.address);
    console.log("\n" + "=".repeat(70));

    // Save to file
    const addresses = {
        network: hre.network.name,
        tokenAddress: tokenAddress,
        stakingAddress: stakingAddress,
        deployer: deployer.address,
        timestamp: new Date().toISOString()
    };

    fs.writeFileSync(
        'deployed-addresses.json',
        JSON.stringify(addresses, null, 2)
    );

    console.log("\n✅ Addresses saved to: deployed-addresses.json");
    console.log("\nNext steps:");
    console.log("1. Update .env with these addresses");
    console.log("2. Update .env.local for frontend");
    console.log("3. Verify on BSCScan:");
    console.log(`   npx hardhat verify --network bscTestnet ${tokenAddress}`);
    console.log(`   npx hardhat verify --network bscTestnet ${stakingAddress} ${tokenAddress}`);
    console.log("\n" + "=".repeat(70) + "\n");
}

main()
    .then(() => process.exit(0))
    .catch((error) => {
        console.error("\n❌ ERROR:", error);
        process.exit(1);
    });
