import connectDB from '../../../lib/mongodb';
import Transaction from '../../../models/Transaction';

export default async function handler(req, res) {
    if (req.method !== 'GET') {
        return res.status(405).json({ error: 'Method not allowed' });
    }

    try {
        await connectDB();

        const { userWallet, type, limit = 50 } = req.query;

        if (!userWallet) {
            return res.status(400).json({ error: 'Wallet address required' });
        }

        const query = { userWallet: userWallet.toLowerCase() };

        if (type) {
            query.type = type;
        }

        const transactions = await Transaction.find(query)
            .sort({ createdAt: -1 })
            .limit(parseInt(limit));

        return res.status(200).json({
            success: true,
            transactions: transactions.map(tx => ({
                id: tx._id,
                type: tx.type,
                amount: tx.amount,
                fee: tx.fee,
                received: tx.received,
                txHash: tx.txHash,
                status: tx.status,
                createdAt: tx.createdAt,
                metadata: tx.metadata,
            })),
        });

    } catch (error) {
        console.error('Transaction history error:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
