import connectDB from '../../../lib/mongodb';
import Stake from '../../../models/Stake';

export default async function handler(req, res) {
    if (req.method !== 'GET') {
        return res.status(405).json({ error: 'Method not allowed' });
    }

    try {
        await connectDB();

        const { userWallet } = req.query;

        if (!userWallet) {
            return res.status(400).json({ error: 'Wallet address required' });
        }

        const stakes = await Stake.find({
            userWallet: userWallet.toLowerCase()
        }).sort({ createdAt: -1 });

        return res.status(200).json({
            success: true,
            stakes: stakes.map(stake => ({
                id: stake._id,
                packageName: stake.packageName,
                amount: stake.amount,
                dailyRate: stake.dailyRate,
                durationDays: stake.durationDays,
                startDate: stake.startDate,
                endDate: stake.endDate,
                status: stake.status,
                totalClaimed: stake.totalClaimed,
                daysRemaining: Math.max(0, Math.ceil((new Date(stake.endDate) - new Date()) / (1000 * 60 * 60 * 24))),
            })),
        });

    } catch (error) {
        console.error('Get stakes error:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
