import connectDB from '../../../lib/mongodb';
import Balance from '../../../models/Balance';

export default async function handler(req, res) {
    if (req.method !== 'GET') {
        return res.status(405).json({ error: 'Method not allowed' });
    }

    try {
        await connectDB();

        const { userWallet } = req.query;

        if (!userWallet) {
            return res.status(400).json({ error: 'Wallet address required' });
        }

        let balance = await Balance.findOne({ userWallet: userWallet.toLowerCase() });

        if (!balance) {
            balance = {
                dailyRewards: 0,
                referralBonus: 0,
                managerBonus: 0,
            };
        }

        return res.status(200).json({
            success: true,
            balance: {
                dailyRewards: balance.dailyRewards || 0,
                referralBonus: balance.referralBonus || 0,
                managerBonus: balance.managerBonus || 0,
                total: (balance.dailyRewards || 0) + (balance.referralBonus || 0) + (balance.managerBonus || 0),
            },
        });

    } catch (error) {
        console.error('Get balance error:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
