import connectDB from '../../../lib/mongodb';
import User from '../../../models/User';

export default async function handler(req, res) {
    if (req.method !== 'POST') {
        return res.status(405).json({ error: 'Method not allowed' });
    }

    try {
        await connectDB();

        const { walletAddress, referrerCode } = req.body;

        if (!walletAddress) {
            return res.status(400).json({ error: 'Wallet address required' });
        }

        // Check if user already exists
        let user = await User.findOne({ walletAddress: walletAddress.toLowerCase() });

        if (user) {
            return res.status(200).json({
                success: true,
                message: 'User already registered',
                user: {
                    walletAddress: user.walletAddress,
                    referralCode: user.referralCode,
                    managerLevel: user.managerLevel,
                    groupTurnover: user.groupTurnover,
                },
            });
        }

        // Find referrer if code provided
        let referrerAddress = null;
        if (referrerCode) {
            const referrer = await User.findOne({ referralCode: referrerCode.toUpperCase() });
            if (referrer) {
                referrerAddress = referrer.walletAddress;
            }
        }

        // Create new user
        user = new User({
            walletAddress: walletAddress.toLowerCase(),
            referrerAddress: referrerAddress,
            referralCode: walletAddress.substring(2, 10).toUpperCase(),
        });

        await user.save();

        return res.status(201).json({
            success: true,
            message: 'User registered successfully',
            user: {
                walletAddress: user.walletAddress,
                referralCode: user.referralCode,
                referrerAddress: user.referrerAddress,
            },
        });

    } catch (error) {
        console.error('Registration error:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
