import connectDB from '../../../lib/mongodb';
import { isOwner } from '../../../lib/adminAuth';
import Settings from '../../../models/Settings';

export default async function handler(req, res) {
    try {
        await connectDB();

        const { userWallet } = req.query || req.body;

        if (!userWallet) {
            return res.status(400).json({ error: 'Wallet address required' });
        }

        // Check if owner
        if (!isOwner(userWallet)) {
            return res.status(403).json({
                success: false,
                error: 'Unauthorized - Owner access only'
            });
        }

        if (req.method === 'GET') {
            // Get settings
            const settings = await Settings.getSettings();

            return res.status(200).json({
                success: true,
                settings
            });
        }

        if (req.method === 'POST') {
            // Update settings
            const { referralLevels, managerLevels, staking } = req.body;

            const settings = await Settings.getSettings();

            if (referralLevels) {
                settings.referralLevels = { ...settings.referralLevels, ...referralLevels };
            }

            if (managerLevels) {
                settings.managerLevels = { ...settings.managerLevels, ...managerLevels };
            }

            if (staking) {
                settings.staking = { ...settings.staking, ...staking };
            }

            await settings.save();

            return res.status(200).json({
                success: true,
                message: 'Settings updated successfully',
                settings
            });
        }

        return res.status(405).json({ error: 'Method not allowed' });

    } catch (error) {
        console.error('Settings API error:', error);
        return res.status(500).json({
            success: false,
            error: 'Internal server error',
            message: error.message
        });
    }
}
