const mongoose = require('mongoose');

const userSchema = new mongoose.Schema({
    walletAddress: {
        type: String,
        required: true,
        unique: true,
        lowercase: true,
    },
    referrerAddress: {
        type: String,
        lowercase: true,
        default: null,
    },
    referralCode: {
        type: String,
        unique: true,
        required: true,
    },
    managerLevel: {
        type: Number,
        default: 0,
        min: 0,
        max: 5,
    },
    groupTurnover: {
        type: Number,
        default: 0,
    },
    managerBonusClaimed: {
        type: Map,
        of: Boolean,
        default: {
            level1: false,
            level2: false,
            level3: false,
            level4: false,
            level5: false,
        },
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
});

// Generate referral code
userSchema.methods.generateReferralCode = function () {
    return this.walletAddress.substring(2, 10).toUpperCase();
};

module.exports = mongoose.models.User || mongoose.model('User', userSchema);
