const mongoose = require('mongoose');

const transactionSchema = new mongoose.Schema({
    userWallet: {
        type: String,
        required: true,
        lowercase: true,
    },
    type: {
        type: String,
        enum: ['stake', 'withdraw_daily', 'withdraw_referral', 'withdraw_manager', 'referral_bonus', 'manager_bonus'],
        required: true,
    },
    amount: {
        type: Number,
        required: true,
    },
    fee: {
        type: Number,
        default: 0,
    },
    received: {
        type: Number,
        default: 0,
    },
    txHash: {
        type: String,
        default: null,
    },
    status: {
        type: String,
        enum: ['pending', 'success', 'failed'],
        default: 'pending',
    },
    metadata: {
        type: mongoose.Schema.Types.Mixed,
        default: {},
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
});

// Index for user transaction history
transactionSchema.index({ userWallet: 1, createdAt: -1 });
transactionSchema.index({ type: 1, status: 1 });

module.exports = mongoose.models.Transaction || mongoose.model('Transaction', transactionSchema);
