const mongoose = require('mongoose');

const stakeSchema = new mongoose.Schema({
    userWallet: {
        type: String,
        required: true,
        lowercase: true,
    },
    packageId: {
        type: Number,
        required: true,
        min: 0,
        max: 4,
    },
    packageName: {
        type: String,
        required: true,
        enum: ['BASIC', 'STANDARD', 'PRO', 'MINI PRO', 'MAX PRO'],
    },
    amount: {
        type: Number,
        required: true,
    },
    dailyRate: {
        type: Number,
        required: true,
    },
    durationDays: {
        type: Number,
        required: true,
    },
    startDate: {
        type: Date,
        required: true,
        default: Date.now,
    },
    endDate: {
        type: Date,
        required: true,
    },
    status: {
        type: String,
        enum: ['active', 'completed'],
        default: 'active',
    },
    totalClaimed: {
        type: Number,
        default: 0,
    },
    txHash: {
        type: String,
        required: true,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
});

// Index for queries
stakeSchema.index({ userWallet: 1, status: 1 });
stakeSchema.index({ status: 1, endDate: 1 });

module.exports = mongoose.models.Stake || mongoose.model('Stake', stakeSchema);
