const mongoose = require('mongoose');

const settingsSchema = new mongoose.Schema({
    // Referral levels configuration (percentages)
    referralLevels: {
        level1: { type: Number, default: 8 },   // 8%
        level2: { type: Number, default: 5 },   // 5%
        level3: { type: Number, default: 3 },   // 3%
        level4: { type: Number, default: 2 },   // 2%
        level5: { type: Number, default: 1 }    // 1%
    },

    // Manager levels configuration
    managerLevels: {
        level1: {
            turnover: { type: Number, default: 1000 },
            bonus: { type: Number, default: 2 }        // 2%
        },
        level2: {
            turnover: { type: Number, default: 3000 },
            bonus: { type: Number, default: 3.5 }      // 3.5%
        },
        level3: {
            turnover: { type: Number, default: 5000 },
            bonus: { type: Number, default: 6 }        // 6%
        },
        level4: {
            turnover: { type: Number, default: 7500 },
            bonus: { type: Number, default: 10 }       // 10%
        },
        level5: {
            turnover: { type: Number, default: 10000 },
            bonus: { type: Number, default: 15 }       // 15%
        }
    },

    // Staking configuration
    staking: {
        minWithdrawal: { type: Number, default: 10 },   // 10 KZD
        withdrawalFee: { type: Number, default: 5 }     // 5%
    },

    // Singleton - only one settings document
    singleton: { type: Boolean, default: true, unique: true }
}, {
    timestamps: true
});

// Ensure only one settings document exists
settingsSchema.statics.getSettings = async function () {
    let settings = await this.findOne({ singleton: true });

    if (!settings) {
        settings = await this.create({ singleton: true });
    }

    return settings;
};

module.exports = mongoose.models.Settings || mongoose.model('Settings', settingsSchema);
