const mongoose = require('mongoose');

const balanceSchema = new mongoose.Schema({
    userWallet: {
        type: String,
        required: true,
        unique: true,
        lowercase: true,
    },
    dailyRewards: {
        type: Number,
        default: 0,
    },
    referralBonus: {
        type: Number,
        default: 0,
    },
    managerBonus: {
        type: Number,
        default: 0,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
});

// Method to get total withdrawable balance
balanceSchema.methods.getTotalBalance = function () {
    return this.dailyRewards + this.referralBonus + this.managerBonus;
};

// Update timestamp on save
balanceSchema.pre('save', function (next) {
    this.updatedAt = Date.now();
    next();
});

module.exports = mongoose.models.Balance || mongoose.model('Balance', balanceSchema);
