export const KZD_TOKEN_ABI = [
    "function name() view returns (string)",
    "function symbol() view returns (string)",
    "function decimals() view returns (uint8)",
    "function totalSupply() view returns (uint256)",
    "function balanceOf(address account) view returns (uint256)",
    "function transfer(address to, uint256 amount) returns (bool)",
    "function allowance(address owner, address spender) view returns (uint256)",
    "function approve(address spender, uint256 amount) returns (bool)",
    "function transferFrom(address from, address to, uint256 amount) returns (bool)"
];

export const STAKING_CONTRACT_ABI = [
    "function stake(uint256 packageId) external",
    "function withdraw(uint256 amount) external",
    "function getUserStakesCount(address user) view returns (uint256)",
    "function getUserStake(address user, uint256 index) view returns (uint256 packageId, uint256 amount, uint256 startTime, uint256 endTime, bool isActive)",
    "function getPackage(uint256 packageId) view returns (string name, uint256 amount, uint256 dailyRate, uint256 durationDays, bool isActive)",
    "function getContractBalance() view returns (uint256)",
    "function totalStaked(address user) view returns (uint256)",
    "function pause() external",
    "function unpause() external",
    "function fundContract(uint256 amount) external",
    "function updatePackage(uint256 packageId, string name, uint256 amount, uint256 dailyRate, uint256 durationDays, bool isActive) external",
    "event Staked(address indexed user, uint256 packageId, uint256 amount, uint256 startTime, uint256 endTime)",
    "event Withdrawn(address indexed user, uint256 amount, uint256 fee, uint256 received)"
];

export const BSC_TESTNET_CONFIG = {
    chainId: 97,
    chainName: 'BSC Testnet',
    nativeCurrency: {
        name: 'BNB',
        symbol: 'BNB',
        decimals: 18
    },
    rpcUrls: ['https://data-seed-prebsc-1-s1.binance.org:8545/'],
    blockExplorerUrls: ['https://testnet.bscscan.com/']
};

export const BSC_MAINNET_CONFIG = {
    chainId: 56,
    chainName: 'BSC Mainnet',
    nativeCurrency: {
        name: 'BNB',
        symbol: 'BNB',
        decimals: 18
    },
    rpcUrls: ['https://bsc-dataseed.binance.org/'],
    blockExplorerUrls: ['https://bscscan.com/']
};

export const PACKAGES = [
    { id: 0, name: 'BASIC', amount: 10, rate: 1.5, days: 90, color: '#4caf50' },
    { id: 1, name: 'STANDARD', amount: 50, rate: 1.6, days: 80, color: '#2196f3' },
    { id: 2, name: 'PRO', amount: 100, rate: 1.6, days: 70, color: '#9c27b0' },
    { id: 3, name: 'MINI PRO', amount: 500, rate: 1.9, days: 60, color: '#ff9800' },
    { id: 4, name: 'MAX PRO', amount: 1000, rate: 2.5, days: 50, color: '#f44336' },
];
