/**
 * Admin Authentication Middleware
 * Check if connected wallet is the contract owner
 */

const OWNER_WALLET = process.env.OWNER_WALLET?.toLowerCase() || '0xb6aa112fc337ef78e9375417d51670d050ef990a';

/**
 * Check if wallet address is the owner
 * @param {string} walletAddress - Wallet address to check
 * @returns {boolean} - True if owner
 */
function isOwner(walletAddress) {
    if (!walletAddress) return false;
    return walletAddress.toLowerCase() === OWNER_WALLET;
}

/**
 * API Middleware to check if requester is owner
 * Usage: Add to API route handlers
 */
function requireOwner(req, res, next) {
    const { userWallet } = req.query || req.body;

    if (!userWallet) {
        return res.status(400).json({
            success: false,
            error: 'Wallet address required'
        });
    }

    if (!isOwner(userWallet)) {
        return res.status(403).json({
            success: false,
            error: 'Unauthorized - Owner access only'
        });
    }

    next();
}

module.exports = {
    isOwner,
    requireOwner,
    OWNER_WALLET
};
