const { ethers } = require('hardhat');

// Encode constructor arguments for Staking Contract
// Constructor: constructor(address _tokenAddress)
// Argument: 0x7dFfa9f69Ac6676c478f004a3c6dA9e7C5851802

const tokenAddress = '0x7dFfa9f69Ac6676c478f004a3c6dA9e7C5851802';

const encoded = ethers.AbiCoder.defaultAbiCoder().encode(
    ['address'],
    [tokenAddress]
);

console.log('\n' + '='.repeat(80));
console.log('CONSTRUCTOR ARGUMENTS ABI-ENCODED');
console.log('='.repeat(80));
console.log('\nFor Staking Contract Verification:');
console.log('\nToken Address:', tokenAddress);
console.log('\nABI-Encoded Constructor Arguments:');
console.log(encoded.slice(2)); // Remove '0x' prefix
console.log('\n' + '='.repeat(80));
console.log('\nCopy the encoded value above and paste into BSCScan');
console.log('"Constructor Arguments ABI-encoded" field');
console.log('='.repeat(80) + '\n');
