const cron = require('node-cron');
const { exec } = require('child_process');

console.log('🚀 Cron Job Scheduler Started');

// Run daily rewards every day at 00:00 (Midnight)
cron.schedule('0 0 * * *', () => {
    console.log('⏰ Executing Daily Rewards Distribution...');

    exec('npm run cron:daily', (error, stdout, stderr) => {
        if (error) {
            console.error(`❌ Error executing cron: ${error.message}`);
            return;
        }
        if (stderr) {
            console.error(`⚠️ Stderr: ${stderr}`);
        }
        console.log(`✅ Output: ${stdout}`);
    });
}, {
    timezone: "Asia/Jakarta" // Sesuaikan timezone server/target user
});

console.log('✅ Scheduler active: Running daily at 00:00 Asia/Jakarta');
