# KUZADESIGN Smart Contracts

## Contracts

### 1. KUZADESIGNToken.sol
ERC20 token contract untuk testing di BSC Testnet.

**Features:**
- Standard ERC20 implementation
- Total Supply: 1,000,000,000 KZD (1 billion)
- Mint function (owner only, untuk testing)
- Burn function  
- 18 decimals

### 2. KZDStaking.sol
Main staking contract dengan 5 paket.

**Features:**
- 5 predefined packages
- Automatic stake recording
- Withdrawal with 5% fee
- ReentrancyGuard protection
- Pausable functionality
- Owner management functions

## Packages

| ID | Name | Amount | Daily Rate | Duration |
|----|------|--------|------------|----------|
| 0 | BASIC | 10 KZD | 1.5% | 90 days |
| 1 | STANDARD | 50 KZD | 1.6% | 80 days |
| 2 | PRO | 100 KZD | 1.6% | 70 days |
| 3 | MINI PRO | 500 KZD | 1.9% | 60 days |
| 4 | MAX PRO | 1000 KZD | 2.5% | 50 days |

## Compile

```bash
npx hardhat compile
```

## Deploy

**Testnet:**
```bash
npx hardhat run scripts/deploy.js --network bscTestnet
```

**Mainnet:**
```bash
npx hardhat run scripts/deploy.js --network bscMainnet
```

## Verify

```bash
# Token
npx hardhat verify --network bscTestnet [TOKEN_ADDRESS]

# Staking (with constructor arg)
npx hardhat verify --network bscTestnet [STAKING_ADDRESS] [TOKEN_ADDRESS]
```

## Security

- ✅ ReentrancyGuard on critical functions
- ✅ Pausable for emergency stop
- ✅ OnlyOwner for admin functions
- ✅ Input validation
- ✅ Safe ERC20 operations

## Testing

Test locally:
```bash
npx hardhat test
```

## ABIs

ABIs are automatically generated in `artifacts/contracts/` after compilation.

For frontend integration, use:
- `artifacts/contracts/KUZADESIGNToken.sol/KUZADESIGNToken.json`
- `artifacts/contracts/KZDStaking.sol/KZDStaking.json`

Or use the simplified ABIs in `lib/web3Config.js`.
