// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";
import "@openzeppelin/contracts/access/Ownable.sol";

/**
 * @title KUZADESIGN Token
 * @dev ERC20 Token untuk testing staking system di BSC Testnet
 */
contract KUZADESIGNToken is ERC20, Ownable {
    constructor() ERC20("KUZADESIGN", "KZD") Ownable(msg.sender) {
        // Mint 1 billion tokens (1,000,000,000 dengan 18 decimals)
        _mint(msg.sender, 1_000_000_000 * 10**decimals());
    }

    /**
     * @dev Fungsi untuk mint token tambahan (hanya untuk testing)
     * @param to Address penerima token
     * @param amount Jumlah token yang akan di-mint
     */
    function mint(address to, uint256 amount) external onlyOwner {
        _mint(to, amount);
    }

    /**
     * @dev Fungsi untuk burn token
     * @param amount Jumlah token yang akan di-burn
     */
    function burn(uint256 amount) external {
        _burn(msg.sender, amount);
    }
}
