import { useState, useEffect } from 'react';
import { useRouter } from 'next/router';

export default function BottomNav() {
    const router = useRouter();
    const [currentPath, setCurrentPath] = useState('/');
    const [isAdmin, setIsAdmin] = useState(false);

    useEffect(() => {
        setCurrentPath(router.pathname);
        checkAdmin();
    }, [router.pathname]);

    const checkAdmin = async () => {
        if (typeof window.ethereum !== 'undefined') {
            try {
                const accounts = await window.ethereum.request({ method: 'eth_accounts' });
                if (accounts.length > 0) {
                    const currentAccount = accounts[0].toLowerCase();
                    const ownerWallet = (process.env.NEXT_PUBLIC_OWNER_WALLET || '').toLowerCase();
                    setIsAdmin(currentAccount === ownerWallet);
                } else {
                    setIsAdmin(false);
                }
            } catch (error) {
                console.error('Error checking admin:', error);
                setIsAdmin(false);
            }
        }
    };

    const navItems = [
        { icon: '🏠', label: 'Home', path: '/' },
        { icon: '💎', label: 'Stake', path: '/stake' },
        { icon: '👥', label: 'Team', path: '/team' },
        { icon: '💰', label: 'Withdraw', path: '/withdraw' },
        { icon: '👤', label: 'Profile', path: '/profile' },
    ];

    // Add Admin menu only if verified owner
    if (isAdmin) {
        navItems.push({ icon: '⚙️', label: 'Admin', path: '/admin' });
    }

    const handleClick = (path) => {
        router.push(path);
    };

    return (
        <nav className="bottom-nav slide-up">
            {navItems.map((item) => (
                <button
                    key={item.path}
                    className={`nav-item ripple ${item.path === '/admin'
                            ? (currentPath.startsWith('/admin') ? 'active' : '')
                            : (currentPath === item.path ? 'active' : '')
                        }`}
                    onClick={() => handleClick(item.path)}
                >
                    <span className="nav-icon">{item.icon}</span>
                    <span className="nav-label">{item.label}</span>
                </button>
            ))}
        </nav>
    );
}
