require('dotenv').config();
const { ethers } = require('ethers');

async function getDeploymentCost() {
    const provider = new ethers.JsonRpcProvider('https://bsc-testnet.blockpi.network/v1/rpc/public');

    const stakingTxHash = '0xc760c2263f0cea3497ba32d08e0424789f54d8d1b41dfc31d6732b7dab7ab885';

    console.log('\n' + '='.repeat(80));
    console.log('CEK BIAYA DEPLOY STAKING CONTRACT');
    console.log('='.repeat(80));

    try {
        console.log('\n📊 Mengambil data transaksi dari BSC Testnet...');
        console.log('TX Hash:', stakingTxHash);

        const [receipt, tx] = await Promise.all([
            provider.getTransactionReceipt(stakingTxHash),
            provider.getTransaction(stakingTxHash)
        ]);

        if (!receipt || !tx) {
            throw new Error('Transaction not found');
        }

        const gasUsed = receipt.gasUsed;
        const gasPrice = tx.gasPrice;
        const gasCostWei = gasUsed * gasPrice;
        const gasCostBNB = ethers.formatEther(gasCostWei);

        console.log('\n' + '='.repeat(80));
        console.log('HASIL ANALISIS GAS - STAKING CONTRACT');
        console.log('='.repeat(80));
        console.log('\n⛽ Gas Used:', gasUsed.toString(), 'units');
        console.log('💵 Gas Price:', ethers.formatUnits(gasPrice, 'gwei'), 'Gwei');
        console.log('\n💰 TOTAL BIAYA DEPLOY:');
        console.log('   ', gasCostBNB, 'BNB');

        // Estimate untuk mainnet dengan berbagai harga BNB
        console.log('\n📈 Estimasi Biaya di MAINNET:');
        const bnbPrices = [200, 250, 300, 350, 400, 450, 500];
        console.log('\n   Harga BNB    |    Biaya Deploy');
        console.log('   ' + '-'.repeat(40));
        bnbPrices.forEach(price => {
            const usd = parseFloat(gasCostBNB) * price;
            console.log(`   $${price.toString().padEnd(12)} |    ~$${usd.toFixed(4)}`);
        });

        console.log('\n' + '='.repeat(80));
        console.log('CATATAN PENTING:');
        console.log('='.repeat(80));
        console.log('✓ Ini biaya untuk STAKING CONTRACT saja');
        console.log('✓ Deploy TOKEN CONTRACT butuh biaya terpisah (~sama)');
        console.log('✓ Transfer 100k KZD ke contract juga butuh gas (~lebih kecil)');
        console.log('✓ Total deployment = Token + Staking + Transfer');
        console.log('✓ Testnet = gratis (BNB testnet)');
        console.log('✓ Mainnet = perlu BNB real');
        console.log('\n' + '='.repeat(80) + '\n');

    } catch (error) {
        console.log('\n❌ Tidak bisa akses RPC');
        console.log('Error:', error.message);
        console.log('\n💡 CEK MANUAL DI BSCSCAN:');
        console.log('='.repeat(80));
        console.log('Link: https://testnet.bscscan.com/tx/' + stakingTxHash);
        console.log('\nPada halaman tersebut, cari:');
        console.log('- "Transaction Fee" = total biaya dalam BNB');
        console.log('- "Gas Used" = jumlah gas yang dipakai');
        console.log('- "Gas Price" = harga per unit gas');
        console.log('\n' + '='.repeat(80) + '\n');
    }
}

getDeploymentCost()
    .then(() => process.exit(0))
    .catch((error) => {
        console.error('\n❌ Error:', error.message);
        process.exit(1);
    });
