# KUZADESIGN Web3 Staking System

![BSC](https://img.shields.io/badge/BSC-Testnet-yellow)
![Next.js](https://img.shields.io/badge/Next.js-14-black)
![MongoDB](https://img.shields.io/badge/MongoDB-Local-green)
![Solidity](https://img.shields.io/badge/Solidity-0.8.20-blue)

Sistem staking Web3 lengkap untuk token KUZADESIGN (KZD) di Binance Smart Chain dengan referral 5 level dan bonus manager.

## ✨ Features

### 🎯 Staking Packages
- **BASIC**: 10 KZD • 1.5% daily • 90 days
- **STANDARD**: 50 KZD • 1.6% daily • 80 days
- **PRO**: 100 KZD • 1.6% daily • 70 days
- **MINI PRO**: 500 KZD • 1.9% daily • 60 days
- **MAX PRO**: 1000 KZD • 2.5% daily • 50 days

### 👥 Referral System (5 Levels)
- **Level 1**: 8% dari staking amount
- **Level 2**: 5% dari staking amount
- **Level 3**: 3% dari staking amount
- **Level 4**: 2% dari staking amount
- **Level 5**: 1% dari staking amount

### 👑 Manager Bonus (One-time per level)
- **Manager 1**: 1,000 KZD turnover → 2% bonus
- **Manager 2**: 3,000 KZD turnover → 3.5% bonus
- **Manager 3**: 5,000 KZD turnover → 6% bonus
- **Manager 4**: 7,500 KZD turnover → 10% bonus
- **Manager 5**: 10,000 KZD turnover → 15% bonus

### 💰 Withdrawal
- Minimum: 10 KZD
- Admin Fee: 5% (deducted from balance)
- 3 Types: Daily Rewards, Referral Bonus, Manager Bonus

## 🏗️ Architecture

```
┌──────────────────┐
│   Smart Contract │  (BSC Blockchain)
│  - KZD Token     │
│  - Staking       │
└────────┬─────────┘
         │
         │ Web3/Ethers.js
         │
┌────────▼─────────┐
│   Next.js App    │  (Frontend + API)
│  - Mobile UI     │
│  - Web3 Connect  │
│  - API Routes    │
└────────┬─────────┘
         │
         │ Mongoose
         │
┌────────▼─────────┐
│    MongoDB       │  (Database)
│  - Users         │
│  - Stakes        │
│  - Balances      │
│  - Transactions  │
└──────────────────┘
```

## 🚀 Quick Start

```bash
# 1. Install dependencies
npm install

# 2. Configure environment
copy .env.example .env
# Edit .env with your settings

# 3. Compile smart contracts
npx hardhat compile

# 4. Deploy to BSC Testnet
npx hardhat run scripts/deploy.js --network bscTestnet

# 5. Start development server
npm run dev
```

Lihat [DEPLOYMENT.md](./DEPLOYMENT.md) untuk panduan lengkap.

## 📁 Project Structure

```
kuzastaking/
├── contracts/              # Smart contracts
│   ├── KUZADESIGNToken.sol
│   └── KZDStaking.sol
├── pages/                  # Next.js pages
│   ├── index.js           # Dashboard
│   ├── stake.js           # Staking packages
│   ├── team.js            # Referral & manager
│   ├── withdraw.js        # Withdrawal
│   ├── profile.js         # History
│   └── api/               # API routes
│       ├── auth/
│       ├── stake/
│       ├── balance/
│       ├── withdraw/
│       ├── team/
│       └── transactions/
├── components/            # React components
│   ├── WalletConnect.js
│   └── BottomNav.js
├── models/                # MongoDB models
│   ├── User.js
│   ├── Stake.js
│   ├── Balance.js
│   └── Transaction.js
├── lib/                   # Utilities
│   ├── mongodb.js
│   ├── web3Config.js
│   ├── referralSystem.js
│   └── managerSystem.js
├── scripts/               # Automation
│   ├── deploy.js
│   └── dailyRewards.js   # Cron job
├── styles/
│   └── globals.css        # Mobile Android theme
└── hardhat.config.js
```

## 🎨 Mobile Android Theme

- **Material Design** inspired
- **Mobile-first** responsive (optimal 360px-480px)
- **Bottom Navigation** Android-style
- **Card-based UI** dengan elevation shadows
- **Smooth animations** dan transitions
- **Dark mode** support (optional)

## 🔐 Security

- ✅ ReentrancyGuard pada smart contract
- ✅ Pausable functionality  
- ✅ OnlyOwner functions
- ✅ Input validation
- ✅ Transaction signing required
- ✅ Environment variables untuk sensitive data

## 🧪 Testing

```bash
# Test smart contracts
npx hardhat test

# Test daily rewards
npm run cron:daily

# Development mode
npm run dev
```

## 📦 Deployment

### Testnet (Development)
```bash
npx hardhat run scripts/deploy.js --network bscTestnet
```

### Mainnet (Production)
```bash
npx hardhat run scripts/deploy.js --network bscMainnet
```

Verify on BSCScan:
```bash
npx hardhat verify --network bscMainnet [CONTRACT_ADDRESS]
```

## 🛠️ Tech Stack

- **Blockchain**: Solidity, Hardhat, Ethers.js
- **Frontend**: Next.js, React
- **Styling**: Vanilla CSS (Material Design)
- **Database**: MongoDB, Mongoose
- **Backend**: Next.js API Routes
- **Automation**: Node-cron, PM2

## 📝 Environment Variables

```env
# Blockchain
PRIVATE_KEY=your_private_key
BSC_TESTNET_RPC=https://data-seed-prebsc-1-s1.binance.org:8545/
BSCSCAN_API_KEY=your_api_key

# Contracts (after deployment)
KZD_TOKEN_ADDRESS=0x...
STAKING_CONTRACT_ADDRESS=0x...
NEXT_PUBLIC_KZD_TOKEN_ADDRESS=0x...
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=0x...

# Database
MONGODB_URI=mongodb://localhost:27017/kuzastaking

# App
PORT=3000
NODE_ENV=development
```

## 📚 API Endpoints

- `POST /api/auth/register` - Register user
- `POST /api/stake/create` - Create stake
- `GET /api/stake/list` - List user stakes
- `GET /api/balance/get` - Get withdrawable balance
- `POST /api/withdraw/request` - Request withdrawal
- `GET /api/team/stats` - Get referral & manager stats
- `GET /api/transactions/history` - Transaction history

## 🎯 Daily Rewards Cron Job

Automatically runs every day at 00:00 to:
1. Calculate daily rewards for all active stakes
2. Add rewards to user balances
3. Mark completed stakes

Setup with PM2:
```bash
pm2 start scripts/dailyRewards.js --cron "0 0 * * *" --name "kzd-daily-rewards"
```

## 📱 Mobile Compatibility

- ✅ MetaMask Mobile
- ✅ Trust Wallet
- ✅ WalletConnect support
- ✅ Touch-optimized interactions
- ✅ Responsive 320px - 480px

## 🤝 Contributing

This is a custom project for KUZADESIGN. For modifications, please contact the development team.

## 📄 License

ISC

## 🚨 Disclaimer

This is provided "as is" without warranty. Always audit smart contracts before mainnet deployment. Test thoroughly on testnet first. Never share your private keys.

---

**Built with ❤️ for KUZADESIGN Community**
