# KUZADESIGN Staking - Quick Test Guide

## 🎯 Quick Testing (5 menit)

### 1. Install & Setup (2 menit)

```bash
# 1. Install ethers.js
npm install ethers@6.13.4

# 2. Setup environment
copy .env.example .env
```

Edit `.env` - **isi private key Anda**:
```
PRIVATE_KEY=your_metamask_private_key_here
```

> **Cara dapat private key MetaMask:**
> 1. Open MetaMask > Settings > Security & Privacy
> 2. Click "Reveal Secret Recovery Phrase" atau "Show Private Key"
> 3. Copy private key (JANGAN SHARE!)

### 2. Deploy Contracts (1 menit)

```bash
# Compile
npx hardhat compile

# Deploy ke BSC Testnet  
npx hardhat run scripts/deploy.js --network bscTestnet
```

**Output akan seperti ini:**
```
🪙 KZD Token Address: 0xABC123...
🎯 Staking Contract Address: 0xDEF456...
```

**SIMPAN ADDRESS INI!**

Update `.env.local`:
```bash
NEXT_PUBLIC_KZD_TOKEN_ADDRESS=0xABC123...
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=0xDEF456...
```

### 3. Start App (30 detik)

```bash
# Jalankan aplikasi
npm run dev
```

Buka: http://localhost:3000

### 4. Test Flow (2 menit)

1. **Connect Wallet**
   - Klik "Connect Wallet"
   - Approve di MetaMask
   - Pastikan network = BSC Testnet

2. **Stake Tokens**
   - Klik menu "Stake"
   - Pilih package (contoh: BASIC)
   - Approve token (tunggu konfirmasi)
   - Confirm stake (tunggu konfirmasi)
   - Success! Check dashboard

3. **Test Daily Rewards**
   ```bash
   npm run cron:daily
   ```
   Refresh page → balance daily rewards akan bertambah

4. **Test Withdrawal**
   - Menu "Withdraw"
   - Tab "Daily"
   - Input amount (min 10 KZD)
   - Confirm transaction
   - Check wallet balance

---

## 🆘 Troubleshooting

### "Insufficient funds untuk gas"
**Solusi:** Get free BNB dari https://testnet.bnbchain.org/faucet-smart

### "Cannot connect to MongoDB"
**Solusi:**
```bash
# Windows
net start MongoDB
```

### "Wrong network"
**Solusi:** Di MetaMask, switch ke BSC Testnet (kalau belum ada, akan otomatis ditambahkan saat connect wallet)

### "Transaction failed"
**Solusi:**
1. Check BNB balance untuk gas
2. Approve token dulu sebelum stake
3. Lihat error di MetaMask

---

## 📱 Test di Mobile

1. Check IP komputer:
   ```bash
   ipconfig
   ```

2. Di HP (sambungkan WiFi yang sama):
   - Buka: `http://[IP_KOMPUTER]:3000`
   - Contoh: `http://192.168.1.100:3000`

3. Install MetaMask app di HP
4. Test semua fitur

---

## ✅ Checklist Testing

- [ ] Connect wallet berhasil
- [ ] Approve token berhasil
- [ ] Stake berhasil (cek transaksi di BSCScan)
- [ ] Dashboard menampilkan stake
- [ ] Cron job update balance
- [ ] Withdrawal berhasil
- [ ] Referral link berfungsi (test dengan wallet kedua)
- [ ] Team stats muncul
- [ ] Transaction history tercatat

---

## 🎉 Berhasil?

Kalau semua berfungsi, sistem sudah siap!

**Next Steps:**
1. Test lebih lengkap dengan beberapa wallet
2. Test referral system (5 level)
3. Test manager bonus
4. Kalau OK, deploy ke Mainnet

**Need Help?**
- Check DEPLOYMENT.md untuk guide lengkap
- Review code di repository
- Test ulang di testnet

---

## 🚀 Ready for Mainnet?

Checklist sebelum deploy production:

- [ ] Tested di testnet minimal 1 minggu
- [ ] All features working perfect
- [ ] Contract audit (optional tapi recommended)
- [ ] Prepare BNB untuk gas (mainnet)
- [ ] Backup private key
- [ ] Domain & SSL ready
- [ ] MongoDB production ready
- [ ] Change token contract ke yang asli (0x84bE681966B4AD148Ec435c36Fe5CC30ad3BEbd2)

**Deploy to Mainnet:**
```bash
npx hardhat run scripts/deploy.js --network bscMainnet
```

Good luck! 🎊
