# 🎯 PANDUAN VERIFIKASI CONTRACT - STEP BY STEP

**PENTING:** Ikuti langkah ini dengan teliti untuk verify contracts di BSC Testnet!

---

## 📋 PERSIAPAN

### File yang Sudah Siap:
✅ `flattened-token.sol` - Token contract (ready)  
✅ `flattened-staking.sol` - Staking contract (ready)

### Info yang Dibutuhkan:
✅ Compiler Version: `v0.8.20+commit.a1b79de6`  
✅ Optimization: YES dengan 200 runs  
✅ License: MIT  

---

## 🪙 STEP 1: VERIFY TOKEN CONTRACT

### 1.1 Buka Halaman Verification
**Link:** https://testnet.bscscan.com/verifyContract?a=0x7dFfa9f69Ac6676c478f004a3c6dA9e7C5851802

### 1.2 Isi Form (Halaman 1)
```
✓ Contract Address: 0x7dFfa9f69Ac6676c478f004a3c6dA9e7C5851802
  (sudah auto-fill, jangan diubah)

✓ Compiler Type: Solidity (Single file)

✓ Compiler Version: v0.8.20+commit.a1b79de6
  (PENTING: Pilih exact version ini!)

✓ Open Source License Type: MIT License (MIT)
```

**Klik: "Continue"**

---

### 1.3 Isi Form (Halaman 2)

#### A. Optimization
```
✓ Optimization: Yes
✓ Runs: 200
```

#### B. Solidity Contract Code
1. Buka file: `c:\xampp\htdocs\kuzastaking\flattened-token.sol`
2. Tekan **Ctrl+A** (select all)
3. Tekan **Ctrl+C** (copy)
4. Paste di kotak "Enter the Solidity Contract Code below"

#### C. Constructor Arguments ABI-encoded
```
(Kosongkan - tidak ada constructor arguments)
```

#### D. Contract Library Address
```
(Kosongkan)
```

**Klik: "Verify and Publish"**

### 1.4 Tunggu Hasil
- ✅ **Success:** Akan muncul "Successfully generated ByteCode and ABI"
- ❌ **Error:** Lihat troubleshooting di bawah

---

## 🎯 STEP 2: VERIFY STAKING CONTRACT

### 2.1 Buka Halaman Verification
**Link:** https://testnet.bscscan.com/verifyContract?a=0xd9706FEE1Ed7d788693357D72cBaBC71dB36F000

### 2.2 Isi Form (Halaman 1)
```
✓ Contract Address: 0xd9706FEE1Ed7d788693357D72cBaBC71dB36F000
  (sudah auto-fill, jangan diubah)

✓ Compiler Type: Solidity (Single file)

✓ Compiler Version: v0.8.20+commit.a1b79de6
  (PENTING: Pilih exact version ini!)

✓ Open Source License Type: MIT License (MIT)
```

**Klik: "Continue"**

---

### 2.3 Isi Form (Halaman 2)

#### A. Optimization
```
✓ Optimization: Yes
✓ Runs: 200
```

#### B. Solidity Contract Code
1. Buka file: `c:\xampp\htdocs\kuzastaking\flattened-staking.sol`
2. Tekan **Ctrl+A** (select all)
3. Tekan **Ctrl+C** (copy)
4. Paste di kotak "Enter the Solidity Contract Code below"

#### C. Constructor Arguments ABI-encoded
**PENTING - Copy exact string ini:**
```
0000000000000000000000007dffa9f69ac6676c478f004a3c6da9e7c5851802
```

**Note:** Ini adalah token address dalam format ABI-encoded (64 karakter hex)

#### D. Contract Library Address
```
(Kosongkan)
```

**Klik: "Verify and Publish"**

### 2.4 Tunggu Hasil
- ✅ **Success:** Akan muncul "Successfully generated ByteCode and ABI"
- ❌ **Error:** Lihat troubleshooting di bawah

---

## ✅ STEP 3: VERIFIKASI HASIL

### 3.1 Cek Token Contract
Buka: https://testnet.bscscan.com/address/0x7dFfa9f69Ac6676c478f004a3c6dA9e7C5851802#code

**Harus terlihat:**
- ✅ Green checkmark "Contract Source Code Verified"
- ✅ Tab "Read Contract" bisa dibuka
- ✅ Tab "Write Contract" bisa dibuka
- ✅ Source code terlihat

### 3.2 Cek Staking Contract  
Buka: https://testnet.bscscan.com/address/0xd9706FEE1Ed7d788693357D72cBaBC71dB36F000#code

**Harus terlihat:**
- ✅ Green checkmark "Contract Source Code Verified"
- ✅ Tab "Read Contract" bisa dibuka
- ✅ Tab "Write Contract" bisa dibuka
- ✅ Source code terlihat

---

## 🐛 TROUBLESHOOTING

### Error: "Compiled Bytecode Mismatch"

**Penyebab:** Compiler settings salah

**Solusi:**
1. Pastikan Compiler Version EXACT: `v0.8.20+commit.a1b79de6`
2. Pastikan Optimization = YES
3. Pastikan Runs = 200
4. Try again

---

### Error: "Constructor Arguments Invalid"

**Hanya untuk Staking Contract!**

**Penyebab:** Constructor args salah format

**Solusi:**
1. Pastikan copy exact string (64 karakter):
   ```
   0000000000000000000000007dffa9f69ac6676c478f004a3c6da9e7c5851802
   ```
2. JANGAN ada spasi atau newline
3. JANGAN ada prefix "0x"
4. Try again

---

### Error: "Duplicate Licenses"

**Penyebab:** Flattened file ada multiple SPDX license identifiers

**Solusi:**
1. Buka flattened file
2. Cari semua `// SPDX-License-Identifier:`
3. Hapus semua kecuali yang paling atas
4. Save file
5. Try again dengan file yang sudah diedit

---

### Error Lain

**Solusi umum:**
1. Refresh halaman BSCScan
2. Clear browser cache
3. Try again dari awal
4. Pastikan internet stabil

---

## 📸 SCREENSHOT GUIDE

Jika masih bingung, ini yang harus Anda lihat:

### Halaman 1 - Settings
```
[Contract Address] ← Auto-filled
[Compiler Type] ← Pilih "Solidity (Single file)"
[Compiler Version] ← Pilih "v0.8.20+commit.a1b79de6"
[License] ← Pilih "MIT"

[Continue Button] ← Klik ini
```

### Halaman 2 - Code
```
[Optimization] ← Yes
[Runs] ← 200

[Large Text Box] ← Paste flattened contract code di sini

[Constructor Arguments] ← Kosong untuk Token, Fill untuk Staking

[Verify and Publish Button] ← Klik ini
```

---

## ⏱️ ESTIMASI WAKTU

- **Token Contract:** 3-5 menit
- **Staking Contract:** 3-5 menit
- **Total:** 6-10 menit

---

## ✅ CHECKLIST FINAL

Setelah selesai semua:

- [ ] Token contract verified (green checkmark)
- [ ] Staking contract verified (green checkmark)
- [ ] Bisa buka "Read Contract" tab di kedua contract
- [ ] Bisa buka "Write Contract" tab di kedua contract
- [ ] Source code visible di BSCScan

**Kalau semua ✅ → SELESAI! Contracts verified!** 🎉

---

## 🚀 SETELAH VERIFICATION

### Test di BSCScan
1. Buka "Read Contract" → check balance, totalSupply, etc
2. Buka "Write Contract" → connect wallet & test functions

### Siap untuk Mainnet
✅ Process verification sudah tested  
✅ Tinggal ulang steps yang sama di mainnet nanti  
✅ Compiler settings sudah know yang benar  

---

## 📞 BUTUH BANTUAN?

Jika ada error yang tidak terdaftar di troubleshooting:
1. Screenshot error message
2. Check exact compiler version lagi
3. Verify optimization settings
4. Pastikan constructor args exact (untuk staking)

---

**Good luck! Verification is easy, just follow steps carefully!** 🎯
