# 🚀 Panduan Deploy KUZADESIGN Staking ke Ubuntu Server

Panduan ini akan membantu Anda deploy aplikasi Next.js (Fullstack) ke VPS Ubuntu, termasuk setup MongoDB dan PM2.

## 📋 Prasyarat
- VPS Ubuntu 20.04 / 22.04 LTS
- Akses Root / SSH
- Domain (optional, tapi disarankan)

---

## 1. Persiapan Server

Update server dan install tools dasar:
```bash
sudo apt update && sudo apt upgrade -y
sudo apt install curl git build-essential -y
```

### Install Node.js (v18/v20)
```bash
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt install -y nodejs

# Cek versi
node -v
npm -v
```

---

## 2. Install MongoDB (Database Local)

Install MongoDB Community Edition:

```bash
# Import public key
curl -fsSL https://pgp.mongodb.com/server-7.0.asc | \
   sudo gpg -o /usr/share/keyrings/mongodb-server-7.0.gpg \
   --dearmor

# Create list file (untuk Ubuntu 22.04)
echo "deb [ arch=amd64,arm64 signed-by=/usr/share/keyrings/mongodb-server-7.0.gpg ] https://repo.mongodb.org/apt/ubuntu jammy/mongodb-org/7.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-7.0.list

# Reload local package database
sudo apt update

# Install MongoDB packages
sudo apt install -y mongodb-org

# Start MongoDB service
sudo systemctl start mongod
sudo systemctl enable mongod

# Cek status
sudo systemctl status mongod
```

Setup MongoDB Authentication (Secure):
```bash
mongosh
```
Di dalam mongosh:
```javascript
use admin
db.createUser({
  user: "admin",
  pwd: "StrongAdminPassword123!", // Ganti password
  roles: [ { role: "userAdminAnyDatabase", db: "admin" } ]
})
use kuzastaking
db.createUser({
  user: "kuzauser",
  pwd: "StrongAppPassword123!", // Ganti password
  roles: [ { role: "readWrite", db: "kuzastaking" } ]
})
exit
```

---

## 3. Upload & Setup Aplikasi

### Clone / Upload Source Code
Upload file project Anda ke server (misal ke folder `/var/www/kuzastaking`). Bisa pakai Git atau SCP/FileZilla.
**PENTING:** Jangan upload folder `node_modules`.

```bash
# Contoh jika pakai git
cd /var/www
git clone https://github.com/username/repo.git kuzastaking
cd kuzastaking
```

### Install Dependencies & Build
```bash
# Install package
npm install

# Build Next.js app (Untuk Production)
npm run build
```

---

## 4. Konfigurasi Environment (.env)

Buat file `.env` di server:
```bash
nano .env
```
Isi dengan config production:

```env
# Database
MONGODB_URI=mongodb://kuzauser:StrongAppPassword123!@localhost:27017/kuzastaking?authSource=kuzastaking

# App Config
NODE_ENV=production
NEXT_PUBLIC_WEB_URL=http://web3-stake1.rezocrypto.us
PORT=3000

# Contract Addresses (PAKE YANG TERBARU DARI DEPLOYMENT)
OWNER_WALLET=0x2Cb10eBF939AEb95D19fd86a39aC29bEc6Aa6ed3
NEXT_PUBLIC_OWNER_WALLET=0x2Cb10eBF939AEb95D19fd86a39aC29bEc6Aa6ed3

KZD_TOKEN_ADDRESS=0xD038B30e69Ac230450Ee26C1475D7A83DD16D69f
NEXT_PUBLIC_KZD_TOKEN_ADDRESS=0xD038B30e69Ac230450Ee26C1475D7A83DD16D69f

STAKING_CONTRACT_ADDRESS=0xbc125F4eFd23A7bd6cc5B7abB8c6e87D0f14800F
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=0xbc125F4eFd23A7bd6cc5B7abB8c6e87D0f14800F

# RPC (Saran: Pakai Private RPC/QuickNode untuk Production agar stabil)
BSC_TESTNET_RPC=https://data-seed-prebsc-1-s1.binance.org:8545/
BSC_MAINNET_RPC=https://bsc-dataseed.binance.org/
PRIVATE_KEY=YOUR_PRIVATE_KEY_HERE
BSCSCAN_API_KEY=YOUR_API_KEY
```

---

## 5. Setup PM2 (Process Manager & Cron)

Install PM2 global:
```bash
sudo npm install -g pm2
```

### Jalankan Aplikasi (Next.js)
```bash
# Jalankan app di port 3000
pm2 start npm --name "kuzastaking-app" -- start
```

### Jalankan Cron Job (Scheduler)
Pastikan script cron sudah ada. Kita bisa jalankan script JS terpisah untuk cron.

Buat file `cron-runner.js` di root folder jika belum ada:
```javascript
// cron-runner.js
const cron = require('node-cron');
const { exec } = require('child_process');

console.log('🚀 Cron Job Scheduler Started');

// Run daily rewards every day at 00:00
cron.schedule('0 0 * * *', () => {
  console.log('⏰ Running Daily Rewards...');
  exec('npm run cron:daily', (error, stdout, stderr) => {
    if (error) console.error(`Error: ${error.message}`);
    if (stderr) console.error(`Stderr: ${stderr}`);
    console.log(`Stdout: ${stdout}`);
  });
});
```

Jalankan Cron dengan PM2:
```bash
pm2 start cron-runner.js --name "kuzastaking-cron"
```

### Simpan Config PM2 (Agar Auto-Start saat Reboot)
```bash
pm2 save
pm2 startup
# Copy paste command yang muncul di terminal
```

---

## 6. Setup Nginx & SSL (Agar bisa diakses Public)

Install Nginx:
```bash
sudo apt install nginx -y
```

Buat Config Nginx:
```bash
sudo nano /etc/nginx/sites-available/kuzastaking
```

Isi config dengan domain Anda:
```nginx
server {
    server_name web3-stake1.rezocrypto.us; 

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
    }
}
```

Enable config:
```bash
sudo ln -s /etc/nginx/sites-available/kuzastaking /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx
```

Install SSL (Certbot) agar HTTPS Secure:
```bash
sudo apt install certbot python3-certbot-nginx -y
sudo certbot --nginx -d web3-stake1.rezocrypto.us
```

---

## ✅ Selesai!

Aplikasi sekarang sudah online di `https://web3-stake1.rezocrypto.us`

### Cheat Sheet Maintenance:
- **Lihat Logs:** `pm2 logs`
- **Restart App:** `pm2 restart kuzastaking-app`
- **Update Code:**
  ```bash
  git pull
  npm install
  npm run build
  pm2 restart kuzastaking-app
  ```
