# KUZADESIGN Staking System - Deployment Guide

## ���� Ringkasan Sistem

### Smart Contracts
- **KZD Token**: ERC20 token dengan supply 1 miliar
- **Staking Contract**: 5 paket staking dengan reward harian

### Backend
- **Next.js API Routes**: RESTful API untuk data management
- **MongoDB**: Database untuk user, stakes, balances, transactions
- **Cron Job**: Daily reward calculation

### Frontend
- **Next.js**: React framework dengan mobile Android theme
- **Web3**: Integrasi MetaMask untuk transaksi blockchain
- **Responsive**: Mobile-first design (optimal 360px-480px)

---

## 📋 Prerequisites

1. **Node.js** (v16 atau lebih baru)
2. **MongoDB** (lokal atau cloud)
3. **MetaMask** browser extension
4. **BNB** di wallet untuk gas fees (testnet gratis dari faucet)

---

## 🚀 Step 1: Installation

```bash
cd c:\xampp\htdocs\kuzastaking

# Install dependencies
npm install ethers@6.13.4

# Copy environment file
copy .env.example .env
```

---

## 🔧 Step 2: Configure Environment

Edit file `.env`:

```env
# Blockchain (isi dengan private key wallet Anda)
PRIVATE_KEY=your_private_key_here

# BSCScan API Key (opsional, untuk verify contract)
BSCSCAN_API_KEY=your_bscscan_key_here

# MongoDB
MONGODB_URI=mongodb://localhost:27017/kuzastaking

# Backend
PORT=3000
NODE_ENV=development
```

**PENTING**: Jangan share private key dengan siapapun!

---

## 📝 Step 3: Deploy Smart Contracts

### 3.1 Compile Contracts

```bash
npx hardhat compile
```

### 3.2 Get BSC Testnet BNB

1. Buka https://testnet.bnbchain.org/faucet-smart
2. Masukkan address wallet Anda
3. Klaim BNB gratis (0.5 BNB)

### 3.3 Deploy to BSC Testnet

```bash
npx hardhat run scripts/deploy.js --network bscTestnet
```

Output akan menampilkan:
```
🪙 KZD Token Address: 0x...
🎯 Staking Contract Address: 0x...
```

**SIMPAN ADDRESS INI!**

### 3.4 Update Environment dengan Contract Addresses

Edit `.env` dan tambahkan:

```env
KZD_TOKEN_ADDRESS=0x... (dari output deployment)
STAKING_CONTRACT_ADDRESS=0x... (dari output deployment)
```

Juga create `.env.local` untuk frontend:

```env
NEXT_PUBLIC_KZD_TOKEN_ADDRESS=0x...
NEXT_PUBLIC_STAKING_CONTRACT_ADDRESS=0x...
```

---

## 🗄️ Step 4: Setup MongoDB

### 4.1 Start MongoDB

```bash
# Windows
net start MongoDB

# Atau jika menggunakan MongoDB Compass, buka aplikasinya
```

### 4.2 Verify Connection

Database akan otomatis dibuat saat aplikasi pertama kali running.

---

## ▶️ Step 5: Start Application

### 5.1 Development Mode

```bash
npm run dev
```

Aplikasi akan berjalan di: http://localhost:3000

### 5.2 Setup Daily Rewards Cron Job

Opsi 1 - Manual test:
```bash
npm run cron:daily
```

Opsi 2 - PM2 (untuk production):
```bash
# Install PM2 globally
npm install -g pm2

# Start cron job
pm2 start scripts/dailyRewards.js --cron "0 0 * * *" --name "kzd-daily-rewards"

# Start Next.js app
pm2 start npm --name "kzd-app" -- start

# Save PM2 config
pm2 save

# Auto-start on reboot
pm2 startup
```

---

## 🧪 Step 6: Testing

### 6.1 Connect Wallet

1. Buka http://localhost:3000
2. Klik "Connect Wallet"
3. Approve MetaMask connection
4. Pastikan network = BSC Testnet

### 6.2 Test Staking

1. Buka halaman "Stake"
2. Pilih package (misal BASIC - 10 KZD)
3. Approve token spending
4. Confirm staking transaction
5. Check dashboard - stake akan muncul

### 6.3 Test Daily Rewards

```bash
# Run cron job manually
npm run cron:daily
```

Refresh halaman dan check balance daily rewards bertambah.

### 6.4 Test Referral

1. Copy referral link dari Team page
2. Buka link di browser incognito / wallet lain
3. Connect wallet baru
4. Stake dari wallet baru
5. Check balance referral di wallet pertama

### 6.5 Test Withdrawal

1. Pastikan balance minimal 10 KZD
2. Buka Withdraw page
3. Pilih tab (Daily/Referral/Manager)
4. Input amount
5. Confirm transaction
6. Check wallet balance bertambah

---

## 📱 Step 7: Mobile Testing

### 7.1 Localhost Mobile Access

1. Find your PC IP address:
   ```bash
   ipconfig
   ```

2. Di mobile (sambungkan ke WiFi yang sama):
   - Buka browser
   - Akses: http://[YOUR_IP]:3000
   - Misal: http://192.168.1.100:3000

3. Install MetaMask mobile app
4. Test semua fitur

---

## 🌐 Step 8: Deploy to Production (Mainnet)

### 8.1 Update Environment

Change network to mainnet:

```env
# .env
PRIVATE_KEY=your_mainnet_wallet_private_key
```

### 8.2 Deploy Contracts to BSC Mainnet

**PENTING**: Pastikan punya BNB real untuk gas!  

```bash
npx hardhat run scripts/deploy.js --network bscMainnet
```

### 8.3 Verify Contracts on BSCScan

```bash
npx hardhat verify --network bscMainnet [TOKEN_ADDRESS]
npx hardhat verify --network bscMainnet [STAKING_ADDRESS] [TOKEN_ADDRESS]
```

### 8.4 Deploy Next.js App

Opsi 1 - Vercel (recommended):
```bash
npm install -g vercel
vercel --prod
```

Opsi 2 - Build & serve sendiri:
```bash
npm run build
npm start
```

---

## 🔐 Security Checklist

- [ ] Private key tersimpan aman (JANGAN push ke Git!)
- [ ] `.env` file ada di `.gitignore`
- [ ] MongoDB menggunakan authentication (production)
- [ ] HTTPS enabled (production)
- [ ] Rate limiting untuk API
- [ ] Contract ownership verified
- [ ] Test semua fitur di testnet dulu

---

## 📊 Monitoring

### Check Cron Job Status

```bash
pm2 list
pm2 logs kzd-daily-rewards
```

### Database Stats

```javascript
// Connect to MongoDB
use kuzastaking

// Count documents
db.users.countDocuments()
db.stakes.countDocuments()
db.balances.countDocuments()
db.transactions.countDocuments()

// Check latest transactions
db.transactions.find().sort({createdAt: -1}).limit(10)
```

---

## 🐛 Troubleshooting

### MetaMask tidak connect
- Refresh page
- Clear MetaMask cache
- Check network = BSC Testnet

### Transaction gagal
- Check BNB balance untuk gas fee
- Check approval token sudah dilakukan
- Lihat error di MetaMask

### Daily rewards tidak jalan
- Check PM2 status: `pm2 logs`
- Test manual: `npm run cron:daily`
- Check MongoDB connection

### Referral bonus tidak masuk
- Check referrer address di database
- Verify stake transaction recorded
- Check balance using API: `/api/balance/get?userWallet=0x...`

---

## 📞 Support

Untuk pertanyaan, silakan:
1. Check documentation ini
2. Review code di repository
3. Test di testnet dulu sebelum mainnet

---

## 🎉 Selesai!

Sistem staking KUZADESIGN sudah siap digunakan!

**Testing Flow:**
1. ✅ Connect Wallet
2. ✅ Stake KZD
3. ✅ Wait for daily rewards (atau jalankan cron manual)
4. ✅ Invite referrals
5. ✅ Accumulate group turnover
6. ✅ Withdraw earnings

**Production Checklist:**
- [ ] Contracts deployed ke Mainnet
- [ ] Contracts verified di BSCScan
- [ ] Frontend deployed (Vercel/VPS)
- [ ] MongoDB secured
- [ ] Cron job running
- [ ] SSL certificate installed
- [ ] Domain configured

Good luck! 🚀
