# 🤖 PANDUAN SETUP DAILY REWARDS OTOMATIS

**Tujuan:** Profit otomatis masuk setiap 24 jam tanpa manual trigger

---

## ✅ YANG SUDAH DIBUAT

### 1. Daily Rewards Script
**File:** `scripts/dailyRewards.js`
- Hitung daily rewards untuk semua active stakes
- Update balance users
- Mark completed stakes
- Logging lengkap

### 2. Automated Scheduler
**File:** `scripts/rewardsScheduler.js`
- Menggunakan node-cron
- Jalan otomatis setiap midnight (00:00)
- Timezone: Asia/Jakarta
- Heartbeat setiap jam

### 3. Quick Start Batch File
**File:** `start-rewards-scheduler.bat`
- Double-click untuk start scheduler
- Windows friendly

---

## 🚀 CARA SETUP (3 OPSI)

### OPTION 1: Node-Cron (Recommended untuk Development) ⭐

**Kelebihan:**
- ✅ Simple & mudah
- ✅ Cross-platform
- ✅ Logging to console
- ✅ Easy to debug

**Kekurangan:**
- ❌ Harus tetap running (jangan close terminal)
- ❌ Restart kalau PC restart

**Setup:**
```bash
# Terminal 1: Run aplikasi
npm run dev

# Terminal 2: Run scheduler
npm run rewards:start
```

Atau double-click: `start-rewards-scheduler.bat`

**Keep Running:**
- Jangan close terminal window
- Scheduler akan jalan terus
- Heartbeat setiap jam untuk konfirmasi

---

### OPTION 2: PM2 (Recommended untuk Production) ⭐⭐⭐

**Kelebihan:**
- ✅ Auto-restart on crash
- ✅ Auto-start on PC reboot
- ✅ Process management
- ✅ Logging to files
- ✅ Production-ready

**Setup:**

1. **Install PM2:**
```bash
npm install -g pm2
```

2. **Start Scheduler:**
```bash
pm2 start scripts/rewardsScheduler.js --name "kzd-rewards"
```

3. **Auto-start on Boot:**
```bash
pm2 startup
pm2 save
```

4. **Monitor:**
```bash
# Check status
pm2 status

# View logs
pm2 logs kzd-rewards

# Restart
pm2 restart kzd-rewards

# Stop
pm2 stop kzd-rewards
```

---

### OPTION 3: Windows Task Scheduler (Alternative)

**Kelebihan:**
- ✅ Built-in Windows
- ✅ No extra dependencies
- ✅ Visual interface

**Kekurangan:**
- ⚠️ Windows only
- ⚠️ Lebih complex setup

**Setup:**

1. **Buka Task Scheduler:**
   - Win + R → `taskschd.msc`

2. **Create Basic Task:**
   - Name: "KUZADESIGN Daily Rewards"
   - Description: "Automated daily profit distribution"

3. **Trigger:**
   - Daily
   - Start: 00:00 (midnight)
   - Recur every: 1 days

4. **Action:**
   - Program: `C:\Program Files\nodejs\node.exe`
   - Arguments: `"c:\xampp\htdocs\kuzastaking\scripts\dailyRewards.js"`
   - Start in: `c:\xampp\htdocs\kuzastaking`

5. **Conditions:**
   - ✅ Wake computer to run
   - ✅ Start only if on AC power (optional)

6. **Settings:**
   - ✅ Run task as soon as possible after a missed start
   - ✅ If task fails, restart every: 1 hour

---

## 🧪 TESTING

### Test Manual (Sekarang)
```bash
npm run rewards:test
```

Akan:
- Connect ke MongoDB
- Process semua active stakes
- Calculate & distribute rewards
- Show summary

### Test Scheduler
```bash
# Start scheduler dengan immediate test
node scripts/rewardsScheduler.js --test-now
```

---

## 📊 MONITORING

### Check Logs (PM2)
```bash
pm2 logs kzd-rewards --lines 100
```

### Check MongoDB
```javascript
// Di MongoDB shell
use kuzastaking

// Check balances
db.balances.find().pretty()

// Check stakes
db.stakes.find({ status: 'active' }).pretty()

// Check transactions
db.transactions.find().sort({ createdAt: -1 }).limit(10).pretty()
```

### Check Cron Status
```bash
# PM2
pm2 status

# Node-cron (check terminal output)
# Should show: "💓 Heartbeat: [timestamp] - Scheduler running..."
```

---

## ⚙️ KONFIGURASI

### Ganti Schedule Time

Edit `scripts/rewardsScheduler.js`:

```javascript
// Current: Every day at midnight
cron.schedule('0 0 * * *', () => {

// Options:
// Every 6 hours:  '0 */6 * * *'
// Every 12 hours: '0 */12 * * *'
// Daily at 3 AM:  '0 3 * * *'
```

Cron format: `minute hour day month day-of-week`

---

## 🔧 TROUBLESHOOTING

### Rewards tidak jalan?

1. **Check scheduler status:**
```bash
pm2 status  # atau check terminal
```

2. **Check MongoDB connection:**
```bash
npm run rewards:test
```

3. **Check logs:**
```bash
pm2 logs kzd-rewards  # atau check terminal output
```

### Scheduler crash?

PM2 auto-restart! Check:
```bash
pm2 logs kzd-rewards
```

### PC restart, scheduler stop?

Setup PM2 auto-start:
```bash
pm2 startup
pm2 save
```

---

## 📈 BEST PRACTICES

### Development
Use **node-cron** (Option 1):
```bash
npm run rewards:start
```

### Production
Use **PM2** (Option 2):
```bash
pm2 start scripts/rewardsScheduler.js --name "kzd-rewards"
pm2 save
```

### Testing
Manual test before deploy:
```bash
npm run rewards:test
```

---

## 🎯 CHECKLIST SETUP

- [ ] MongoDB running (`net start MongoDB`)
- [ ] Environment variables configured (`.env`)
- [ ] Test manual rewards: `npm run rewards:test`
- [ ] Choose automation method (PM2 recommended)
- [ ] Setup PM2 or node-cron
- [ ] Configure auto-start on boot (PM2)
- [ ] Test scheduler running
- [ ] Monitor logs untuk confirm jalan
- [ ] Set reminder check logs weekly

---

## 📞 QUICK COMMANDS

```bash
# Test rewards now
npm run rewards:test

# Start scheduler (node-cron)
npm run rewards:start

# Start scheduler (PM2)
pm2 start scripts/rewardsScheduler.js --name kzd-rewards
pm2 save

# Check PM2 status
pm2 status

# View PM2 logs
pm2 logs kzd-rewards

# Restart scheduler
pm2 restart kzd-rewards

# Stop scheduler
pm2 stop kzd-rewards
```

---

## ✅ REKOMENDASI FINAL

**Untuk Sekarang (Testing):**
```bash
npm run rewards:start
```
Biarkan terminal tetap buka.

**Untuk Production:**
```bash
npm install -g pm2
pm2 start scripts/rewardsScheduler.js --name kzd-rewards
pm2 startup
pm2 save
```

Selesai! Rewards akan otomatis distribute setiap 24 jam! 🎉

---

**Schedule:** Setiap hari jam 00:00 (midnight) WIB  
**Timezone:** Asia/Jakarta  
**Auto:** Ya, sampai di-stop manual  
**Restart:** Auto (jika pakai PM2)
